require_relative '../rspec_helper'
require 'wrest'
require 'nokogiri'
require 'vaToolSet/vaToolSet_pageObject'

shared_context "shared steps" do
  before(:all) do
    initializeConfigurations(BASE_URL)
    @vts_po  = VaToolSet_PageObject.new(@driver)
  end

  after(:all) do
    @driver.close
  end

  let(:user_id) { "990" }
  let(:user_id_rightAcc) { "D123401" }
  let(:date) { "20-OCT-12 01.12.32.753000000 PM" }
end

describe '[VaRut-408 - Verify Staff User Disclaimer]' do
  include DriverUtility
  include DBUtility

  context 'AC#VARUT-656|TC#VARUT-653: Redirects if it has not been accepted' do
    include_context "shared steps"

    it "Login" do
      @vts_po.loginLogout.login_ends_on_disclaimer(UserAccess7, true)
    end

    it "Verify the USD elements(Title, Ok , and Cancel)" do
      @vts_po.common.waitWhileSpinnerPresent
      @vts_po.disclaimer.ok_btn_element.when_visible(TIME_OUT_LIMIT)
      # expect(@vts_po.disclaimer.has_expected_title?).to eq(true)
      expect(@vts_po.disclaimer.title_sud_element.text).to eq("Staff User Disclaimer")
      expect(@vts_po.disclaimer.ok_btn_element.present?).to eq(true)
      expect(@vts_po.disclaimer.cancle_btn_element.present?).to eq(true)
    end

    it "cancel USD" do
      @vts_po.disclaimer.cancle_btn_element.click
    end

    it "Verify launchpad title" do
      @vts_po.launchpad.launchpadTitle_element.when_visible(TIME_OUT_LIMIT)
      expect(@vts_po.launchpad.launchpadTitle).to eq("Launchpad")
    end

    it "Logout " do
      @driver.close
    end
  end

  context 'AC#VARUT-656|TC#VARUT-653: Displays Staff User Disclaimer for new user' do
    include_context "shared steps"

    it "Login screen " do
      @vts_po.loginLogout.login_ends_on_disclaimer(UserAccess7, true)
    end

    it "Directs if it has been accepted" do
      @vts_po.common.waitWhileSpinnerPresent()
      @vts_po.disclaimer.ok_btn_element.when_visible(TIME_OUT_LIMIT)
      @vts_po.disclaimer.ok_btn_element.click
    end

    it "Verify VA Tool Set displayed" do
      @vts_po.common.waitWhileSpinnerPresent()
      @vts_po.landing.rightFooter_element.when_visible(TIME_OUT_LIMIT)
      Watir::Wait.until { @vts_po.landing.rightFooter == "Logged in as PROVIDER, SEVEN" }

      expect(@vts_po.landing.leftFooter).to eq("VA Tool Set - v2.3.0")
    end

    it "Logout " do
      @vts_po.loginLogout.logout
    end
  end

  context 'AC#VARUT-656|TC#VARUT-653: Displays SUD, where the current SUD is newer than the date of the SUD the user last signed' do
    include_context "shared steps"

    it "Update the record from DB" do
      updateStaffUserDisclaimerDate(user_id, date)
    end

    it "Login screen" do
      @vts_po.loginLogout.login_ends_on_disclaimer(UserAccess7, false)
    end

    it "Directs if it has been accepted" do
      @vts_po.disclaimer.ok_btn_element.when_visible(TIME_OUT_LIMIT)
      @vts_po.disclaimer.ok_btn_element.click
    end

    it "Verify VA Tool Set displayed" do
      @vts_po.common.waitWhileSpinnerPresent()
      @vts_po.landing.rightFooter_element.when_visible(TIME_OUT_LIMIT)
      Watir::Wait.until { @vts_po.landing.rightFooter == "Logged in as PROVIDER, SEVEN" }

      expect(@vts_po.landing.leftFooter).to eq("VA Tool Set - v2.3.0")
    end

    it "Logout " do
      @vts_po.loginLogout.logout
    end
  end
end